//
//  GSToolSelect.h
//  GlyphsCore
//
//  Created by Georg Seifert on 16.04.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GSSelectableElementProtocol.h>
#import <GlyphsCore/GlyphsPathPlugin.h>

#ifndef GLYPHS_LITE
#import <GlyphsCore/GSShortcutCommandProtocol.h>
#endif

@class GSElement;
@class GSHandle;
@class GSPartsPropertiesViewController;

NS_ASSUME_NONNULL_BEGIN

#ifndef GLYPHS_LITE
@interface GSToolSelect : GlyphsPathPlugin <GSShortcutCommandProtocol>
#else
@interface GSToolSelect : GlyphsPathPlugin
#endif
{
	NSPoint _auswahlDrag;
	CGFloat _auswahlAngle;
	CGFloat _preciseAuswahlAngle;
	CGFloat _grabbedPathTime;
	GSHandle *_referenceHandle;
	BOOL _drawHangulComponentCloud;
}
//@property (nonatomic, retain) GSHandle *selectionBoundsHandle;

@property (nonatomic, retain) GSPartsPropertiesViewController *partsProperties;

- (void)mouseDoubleDown:(NSEvent *)theEvent;

- (void)selectGlyph:(NSEvent *)theEvent;

- (void)selectAtPoint:(NSPoint)point withModifier:(NSEventModifierFlags)modifierFlag;

- (void)selectInPath:(NSBezierPath *)path withModifier:(NSEventModifierFlags)modifierFlag;

- (nullable GSSelectableElement *)elementAtPoint:(NSPoint)loc atLayer:(GSLayer *)layer;

- (nullable GSSelectableElement *)elementAtPoint:(NSPoint)aPoint atLayer:(GSLayer *)layer ignoreLocked:(BOOL)ignoreLocked;

- (NSMutableArray *)elementsInPath:(NSBezierPath *)path atLayer:(GSLayer *)layer modifier:(NSEventModifierFlags)modifierFlag;

- (IBAction)reconnectNodes:(id)sender;

- (IBAction)openCorners:(id)sender;

- (IBAction)decomposeComponentsSelection:(id)sender;

- (IBAction)makeGlobal:(id)sender;

- (IBAction)setBackgroundImageCropToMetrics:(id)sender;

- (nullable GSHandle *)handleForPoint:(NSPoint)aPoint atBounds:(NSRect)bounds angle:(nullable NSAffineTransform *)transform;

@end

NS_ASSUME_NONNULL_END
